package io.agora.avc.net.download

import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.PendingIntent
import android.app.Service
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.Bundle
import android.os.IBinder
import androidx.core.app.NotificationCompat
import androidx.core.app.NotificationManagerCompat
import androidx.core.content.ContextCompat
import io.agora.avc.R
import io.agora.avc.app.master.AgoraActivity

/**
 * Try to ensure that the download is not abort
 */
class DownloadNotificationService : Service() {
    private val progressMax = 100
    private var process: Int = 0
    private val builder by lazy {
        getNotificationBuilder()
    }
    private val notificationManager by lazy {
        NotificationManagerCompat.from(applicationContext)
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        process = intent?.extras?.getInt(KEY_PROCESS) ?: 0
        return if (intent?.action == ACTION_START_FOREGROUND_SERVICE) {
            notifyProgress()
            startForegroundService()
            // Try to solve https://stackoverflow.com/questions/14054588/what-is-start-sticky-start-not-sticky-and-start-redeliver-intent-service
            START_REDELIVER_INTENT
        } else {
            stopForegroundService()
            START_NOT_STICKY
        }
    }

    private fun notifyProgress() {
        val progress = getString(
            R.string.avc_notification_content_download_apk,
            "$process%"
        )
        builder.setProgress(progressMax, process, false).setContentText(progress)
    }

    private fun startForegroundService() {
        startForeground(NOTIFICATION_ID, builder.build())
    }

    private fun stopForegroundService() {
        stopForeground(true)
        stopSelf()
    }

    override fun onBind(intent: Intent?): IBinder? {
        return null
    }

    private fun createNotificationChannel() {
        // Create the NotificationChannel, but only on API 26+ because
        // the NotificationChannel class is new and not in the support library
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val name = getString(R.string.avc_notification_name_download_apk)
            val descriptionText = getString(R.string.avc_notification_des_download_apk)
            val importance = NotificationManager.IMPORTANCE_HIGH
            val channel = NotificationChannel(CHANNEL_ID, name, importance).apply {
                description = descriptionText
            }
            notificationManager.createNotificationChannel(channel)
        }
    }

    private fun getNotificationBuilder(): NotificationCompat.Builder {
        createNotificationChannel()
        return NotificationCompat
            .Builder(this, CHANNEL_ID)
            .setSmallIcon(R.drawable.avc_metroon_icon_status_bar)
            .setColor(ContextCompat.getColor(this, R.color.avc_color_primary))
            .setContentTitle(getString(R.string.avc_notification_title_download_apk))
            .setContentIntent(getContentIntent(this))
            .setPriority(NotificationCompat.PRIORITY_DEFAULT)
            .setVisibility(NotificationCompat.VISIBILITY_PUBLIC)// show details even when lock screen
            .setOnlyAlertOnce(true)// avoid multiple remote user request triggers multiple sounds
            .setAutoCancel(true)
    }

    private fun getContentIntent(context: Context): PendingIntent? {
        return PendingIntent.getActivity(
            context,
            0,
            Intent(context, AgoraActivity::class.java),
            PendingIntent.FLAG_UPDATE_CURRENT
        )
    }

    companion object {

        private const val TAG = "[Service][Download]"
        private const val CHANNEL_ID = "io.agora.avc.notification.DownloadApkNotification"

        private const val ACTION_START_FOREGROUND_SERVICE = "ACTION_START_FOREGROUND_SERVICE"
        private const val ACTION_STOP_FOREGROUND_SERVICE = "ACTION_STOP_FOREGROUND_SERVICE"
        private const val NOTIFICATION_ID = 200
        private const val KEY_PROCESS = "key_process"

        fun startService(context: Context, progress: Int) {
            try {
                val intent = Intent(context, DownloadNotificationService::class.java)
                intent.action = ACTION_START_FOREGROUND_SERVICE
                val bundle = Bundle()
                bundle.putInt(KEY_PROCESS, progress)
                intent.putExtras(bundle)
                context.startService(intent)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }

        fun stopService(context: Context) {
            try {
                val intent = Intent(context, DownloadNotificationService::class.java)
                intent.action = ACTION_STOP_FOREGROUND_SERVICE
                context.startService(intent)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }
}