package io.agora.avc.net.interceptor

import io.agora.avc.manager.bi.BIManagerImpl
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException

class BiInterceptor(private val biManager: BIManagerImpl) : Interceptor {

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val startTime = System.currentTimeMillis()

        val request = chain.request()
        val url = request.url
        var path = url.encodedPath
        if (path.isNotEmpty()) {
            path = path.substring(1)
        }

        val response = chain.proceed(chain.request())
        var elapse = System.currentTimeMillis() - startTime
        var successFlag: Boolean
        var responseCode: Int
        if (response.isSuccessful) {
            successFlag = true
            responseCode = 0
        } else {
            successFlag = false
            responseCode = response.code
        }
        biManager.biRecord(path, successFlag, responseCode, elapse)
        return response
    }

}