package io.agora.avc.net.interceptor

import android.content.Context
import io.agora.avc.MyApplication
import io.agora.avc.utils.AppUtils
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException

/**
 * set request token
 */
class HeaderParamsInterceptor(val context: Context) : Interceptor {

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val request = chain.request()
        val builder = request.newBuilder()
        builder.header(
            "User-Agent",
            "AppVersion/${AppUtils.getAppVersionName()} ${System.getProperty("http.agent") ?: ""}"
        )
        if (context is MyApplication) {
            context.appContainer.localUser?.token?.let {
                builder.addHeader("access_token", it)
            }
        }
        return chain.proceed(builder.build())
    }
}