package io.agora.avc.net.interceptor

import io.agora.avc.net.constant.Constants
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException
import java.util.*

class HostDispatcherInterceptor : Interceptor {
    companion object {
        private val logPath =
            ArrayList<String>()

        init {
            logPath.add("feedback/uploadFeedback")
        }
    }

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val request = chain.request()
        val url = request.url
        var path = url.encodedPath
        if (path.isNotEmpty()) {
            path = path.substring(1)
        }
        if (logPath.contains(path)) {
            val stringBuffer = StringBuffer()
            val newUrl = stringBuffer
                .append(Constants.LOG_BASE_URL)
                .append(path)
                .toString()
            val builder = request.newBuilder().url(newUrl)
            return chain.proceed(builder.build())
        }
        return chain.proceed(chain.request())
    }
}