package io.agora.avc.po

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "problem")
data class Problem(
    @PrimaryKey(autoGenerate = true) val id: Long?,
    @ColumnInfo(name = "issue_name") var issueName: String,
    @ColumnInfo(name = "issue_sid") var issueStreamId: Int,
    @ColumnInfo(name = "opposite_sid") var oppositeStreamId: Int? = null,
    @ColumnInfo(name = "description") var description: String? = null,
    @ColumnInfo(name = "rid") val rid: String,
    @ColumnInfo(name = "sdk_version") val sdkVersion: String,
    @ColumnInfo(name = "app_version") val appVersion: String,
    @ColumnInfo(name = "tags") var tags: String? = null,
    @ColumnInfo(name = "status") var status: Int = 0,
    @ColumnInfo(name = "zip_file_path") var zipFilePath: String,
    @ColumnInfo(name = "reporter_sid") var reporterStreamId: Int?,
    @ColumnInfo(name = "reporter_uid") var reporterUid: String?,
    @ColumnInfo(name = "create_time") val createTime: Long,
    @ColumnInfo(name = "platform") val platform: String,
    @ColumnInfo(name = "issue_id") var issueId: String? // issue id from server
)
