package io.agora.avc.push.hms

import android.app.Service
import android.content.Intent
import android.os.IBinder
import dagger.android.AndroidInjection
import io.agora.avc.push.PushManager
import io.agora.logger.Logger
import javax.inject.Inject

class HuaweiMessageService : Service() {

    @Inject
    lateinit var pushManager: PushManager

    override fun onCreate() {
        super.onCreate()
        AndroidInjection.inject(this)
    }

    override fun onBind(intent: Intent?): IBinder? {
        return null
    }

//    override fun onMessageReceived(message: RemoteMessage?) {
//        var data = """getData: ${message?.dataOfMap}
//            getMessageId: ${message?.messageId}
//            getSendTime: ${message?.sentTime}
//            getMessageType: ${message?.messageType}
//            getTtl: ${message?.ttl}""".trimIndent()
//        Logger.i(TAG, "onMessageReceived:$data")
//
//        val rid = message?.dataOfMap?.get(KEY_RID)
//        val pwd = message?.dataOfMap?.get(KEY_PWD)
//        val requestId = message?.dataOfMap?.get(KEY_REQUEST_ID)
//        val ticket = message?.dataOfMap?.get(KEY_TICKET)
//        val sourceName = message?.dataOfMap?.get(KEY_INVITER)
//        val avatar = message?.dataOfMap?.get(KEY_AVATAR)
//
//        if (rid.isNullOrEmpty() || requestId.isNullOrEmpty() || ticket.isNullOrEmpty()) {
//            Logger.e(TAG, "invalid data:$data")
//            return
//        }
//
//        val incomingData = IncomingData().apply {
//            this.rid = rid
//            this.pwd = pwd
//            this.ticket = ticket
//            this.inviterName = sourceName
//            this.inviterAvatar = avatar
//            this.requestId = requestId
//        }
//        pushManager.onIncomingNew(incomingData)
//    }
//
//    override fun onNewToken(token: String?) {
//        Logger.i(TAG, "onNewToken:$token")
//        if (!token.isNullOrEmpty()) {
//            refreshedTokenToServer(token)
//        }
//    }

    private fun refreshedTokenToServer(token: String) {
        Logger.i(TAG, "sending token to server. token:$token")
        pushManager.sendRegTokenToServer(token)
    }

    private fun isTransparentMessage(msgId: String?): Boolean {
        return msgId == "0"
    }

//    private fun startWorkManagerJob(message: RemoteMessage?) {
//        Logger.d(TAG, "Start new Job processing.")
//    }
//
//    private fun processWithin10s(message: RemoteMessage?) {
//        Logger.d(TAG, "Processing now.")
//    }

    companion object {
        private const val TAG = "HuaweiMessageService"
    }
}