package io.agora.avc.push.xiaomi

import android.app.Service
import android.content.Intent
import android.os.IBinder
import com.agora.valoran.bean.IncomingData
import com.xiaomi.mipush.sdk.MiPushClient
import dagger.android.AndroidInjection
import io.agora.avc.push.PushManager
import io.agora.avc.utils.GsonUtils
import io.agora.logger.Logger
import javax.inject.Inject

class MiPushMessageService : Service() {

    @Inject
    lateinit var pushManager: PushManager

    override fun onCreate() {
        super.onCreate()
        AndroidInjection.inject(this)
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        val extras = intent?.extras
        when (extras?.getString(KEY_COMMAND)) {
            MiPushClient.COMMAND_REGISTER -> {
                extras?.getString(KEY_REG_ID)?.apply {
                    pushManager.sendRegTokenToServer(this)
                }
            }
            COMMAND_INCOMING_CALL -> {
                val data = extras?.getString(KEY_DATA)
                val incomingData = GsonUtils.fromJson(data, IncomingData::class.java)
                onMessageReceived(incomingData)
            }
            else -> {
            }
        }
        return super.onStartCommand(intent, flags, startId)
    }

    override fun onBind(intent: Intent?): IBinder? {
        return null
    }

    private fun onMessageReceived(incomingData: IncomingData) {
        pushManager.onIncomingNew(incomingData)
    }

    fun onNewToken(token: String?) {
        Logger.i(TAG, "onNewToken:$token")
        if (!token.isNullOrEmpty()) {
            refreshedTokenToServer(token)
        }
    }

    private fun refreshedTokenToServer(token: String) {
        Logger.i(TAG, "sending token to server. token:$token")
        pushManager.sendRegTokenToServer(token)
    }

    companion object {
        private const val TAG = "MiPushMessageService"
    }
}