package io.agora.avc.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import io.agora.logger.Logger

class ScreenStatusReceiver : BroadcastReceiver() {

    private var screenStatusChangedListener: OnScreenStatusChangedListener? = null

    override fun onReceive(context: Context?, intent: Intent?) {
        Logger.i(TAG, "screen status changed,new status:${intent?.action}")
        if (SCREEN_ON == intent?.action) {
            screenStatusChangedListener?.onScreenStatusChanged(true)
        } else if (SCREEN_OFF == intent?.action) {
            screenStatusChangedListener?.onScreenStatusChanged(false)
        }
    }

    fun setScreenStatusChangedListener(listener: OnScreenStatusChangedListener) {
        this.screenStatusChangedListener = listener
    }


    interface OnScreenStatusChangedListener {
        fun onScreenStatusChanged(on: Boolean)
    }

    companion object {
        private const val TAG = "[Comm][ScreenStatus]"
        const val SCREEN_ON = "android.intent.action.SCREEN_ON"
        const val SCREEN_OFF = "android.intent.action.SCREEN_OFF"
    }
}