package io.agora.avc.repository

import io.agora.avc.app.address.AddressBookNode
import io.agora.avc.app.address.GroupNode
import io.agora.avc.app.address.MemberNode

interface AddressBookRepository {

    fun queryInvitee(): ArrayList<MemberNode>
    fun queryAdded(): ArrayList<MemberNode>
    fun queryAddressBook(deptId: String): AddressBookNode?
    fun analysisGetResponse(content: String?): AddressBookNode?
    fun analysisSearchResponse(content: String?): List<AddressBookNode>?
    fun clear()
    fun clearInvitee()
    fun clearAdded()
    fun getDeptInfo(seq: Int, dept: String): GroupNode?
    fun saveDeptInfo(dept: String, data: GroupNode)
    fun saveAdded(data: ArrayList<MemberNode>)
}