package io.agora.avc.repository

import io.agora.avc.bo.Attachment
import io.agora.avc.bo.Issue
import io.agora.avc.po.Problem
import io.agora.avc.po.ProblemWithAttach

interface ProblemRepository {

    fun getProblemWithAttach(problemId: Long): ProblemWithAttach
    fun addProblem(issue: Issue, reporterStreamId: Int?, reporterUid: String?): Long
    fun updateProblem(problem: Problem)

    fun addAttach(attachment: Attachment): Long

    fun getAll(): List<Issue>
    fun getIssue(): Issue?
    fun updateIssue(issue: Issue)
    fun clearIssue()

}