package io.agora.avc.repository

import io.agora.avc.bo.*
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.bo.valoran.RoomInfo
import io.reactivex.Observable
import java.util.concurrent.CopyOnWriteArrayList

interface RoomRepository {

    /**
     * --------------------------------------------------
     * Room
     * --------------------------------------------------
     */
    /**
     * create room
     * @param name the same as rid
     */
    fun createRoom(name: String, password: String?, mode: Int, resolution: Int): Room
    fun releaseRoom()

    fun updateRoomInfo(roomInfo: RoomInfo): Room?
    fun rtmJoinedBefore(joined: Boolean)
    fun getRoom(): Room?

    fun findShareStream(): ARoomUser?
    fun findAudioDumpingUser(): ARoomUser?
    fun findParentByStreamId(uid: Int): ARoomUser?

    /**
     * --------------------------------------------------
     * RoomUser list
     * --------------------------------------------------
     */
    fun getRoomUserList(): CopyOnWriteArrayList<ARoomUser>
    fun getOppositeSnapshot(localUser: LocalUser): CopyOnWriteArrayList<ARoomUser>
    fun getCloudRecordInfo(): CloudRecordInfo?
    fun getAssistantInfo(): AssistantInfo?
    fun queryAssistState(): Int
    fun getAudioDumpingUser(): List<ARoomUser>?
    fun saveAudioDumpingUser(user: List<ARoomUser>?)
    fun saveCloudRecordInfo(info: CloudRecordInfo?)
    fun saveAssistantInfo(info: AssistantInfo?)
    fun saveAssistState(state: Int)
    fun moveRoomUser(from: Int, to: Int, user: ARoomUser)

    /**
     * @throws IndexOutOfBoundsException
     */
    fun changeRoomUserListItem(position: Int, user: ARoomUser)
    fun setupRoomUserList(users: List<ARoomUser>)
    fun addRoomUsers(users: List<ARoomUser>)
    fun addRoomUsers(position: Int, users: List<ARoomUser>)
    fun addRoomUser(user: ARoomUser)
    fun addRoomUser(position: Int, user: ARoomUser)
    fun removeRoomUserAt(position: Int)
    fun removeRoomUser(uid: String)
    fun removeRoomUser(streamId: Int)
    fun removeRoomUser(user: ARoomUser)
    fun clearRoomUserList()

    /**
     * --------------------------------------------------
     * MediaUser list
     * --------------------------------------------------
     */
    fun getMajorMedia(): ARoomUser?
    fun saveMajorMedia(user: ARoomUser)
    fun getMediaList(): CopyOnWriteArrayList<ARoomUser>
    fun moveMediaItem(from: Int, to: Int, user: ARoomUser)

    /**
     * @throws IndexOutOfBoundsException
     */
    fun changeMediaListItem(position: Int, user: ARoomUser)
    fun addMediaList(users: List<ARoomUser>)
    fun addMediaList(position: Int, users: List<ARoomUser>)
    fun addMediaItem(user: ARoomUser)
    fun addMediaItem(position: Int, user: ARoomUser)
    fun removeMediaAt(position: Int)
    fun removeMediaItem(uid: String)
    fun removeMediaItem(streamId: Int)
    fun removeMediaItem(user: ARoomUser)
    fun clearMediaList()

    fun queryOtherPublishers(): List<ARoomUser>
    fun queryInnerMeetingInfo(linkId: String): Observable<InnerMeeting>
}