package io.agora.avc.repository

import io.agora.avc.bo.InnerInfo
import io.agora.avc.bo.InnerSession
import io.agora.avc.bo.LocalUser
import io.agora.avc.bo.UserInfo
import io.agora.avc.bo.valoran.ARoomUser
import io.agora.avc.net.bean.BaseNo
import io.agora.avc.utils.DeviceUtils
import io.reactivex.Observable

interface UserRepository {

    var isLocalUserApplyingAssistant: Boolean

    fun resetLocalUser()
    fun updateLocalUserBy(that: ARoomUser)

    /**
     * get sequence:memory -> sp -> net
     * <p>
     *     need call this method at WorkerThread, because may be call network.
     *     When data comes back over the network,MutableLiveData<User> will notify observer
     * </p>
     */
    fun getLocalUser(
        platform: String = DeviceUtils.getPlatform(),
        deviceName: String = DeviceUtils.getModel()
    ): Observable<LocalUser>

    fun getUserInfo(): UserInfo?
    fun saveUserInfo(userInfo: UserInfo)
    fun updateUserInfo(userInfo: UserInfo)

    /**
     * save inner info , info from user use wework or email login
     */
    fun saveInnerInfo(value: InnerInfo?)
    fun updateInnerInfo(value: InnerInfo)
    fun removeInnerInfo()
    fun saveUserName(value: String)

    fun updateUserName(userName: String): Observable<BaseNo>

    fun login(
        token: String,
        source: Int,
        platform: String,
        deviceName: String
    ): Observable<InnerSession>
}