package io.agora.avc.repository.impl

import io.agora.avc.bo.Message
import io.agora.avc.repository.ChatRepository
import io.agora.frame.base.BaseModel
import io.agora.frame.data.IDataRepository
import io.agora.logger.Logger
import java.util.concurrent.CopyOnWriteArrayList
import javax.inject.Inject

class ChatRepositoryImpl @Inject constructor(dataRepository: IDataRepository?) :
    BaseModel(dataRepository), ChatRepository {

    private val messages = CopyOnWriteArrayList<Message>()

    override fun getMessages(): CopyOnWriteArrayList<Message> {
        Logger.i(TAG, "get messages, size:${messages.size}")
        return CopyOnWriteArrayList(messages)
    }

    override fun addMessage(msg: Message) {
        Logger.i(TAG, "add message, message:${msg}")
        messages.add(msg)
    }

    override fun clearMessage() {
        messages.clear()
    }

    companion object {
        private const val TAG = "[Repository][chat]"
    }
}