package io.agora.avc.repository.impl

import io.agora.avc.app.developer.DeveloperOptions
import io.agora.avc.repository.DeveloperRepository
import io.agora.frame.base.BaseModel
import io.agora.frame.data.IDataRepository
import io.agora.logger.LogConverter
import io.agora.logger.Logger
import javax.inject.Inject

class DeveloperRepositoryImpl @Inject constructor(dataRepository: IDataRepository?) :
    BaseModel(dataRepository), DeveloperRepository {

    private val developerOptions = DeveloperOptions()

    override fun getDeveloperOptions(): DeveloperOptions {
        return developerOptions
    }

    override fun isMetaDataEnable(): Boolean {
        return developerOptions.useMeta.apply {
            Logger.i(TAG, "is rtc metadata:${LogConverter.enable(this)}")
        }
    }

    override fun metaDataEnable(enable: Boolean) {
        Logger.i(TAG, "set rtc metadata:${LogConverter.enable(enable)}")
        developerOptions.useMeta = enable
    }

    override fun isRtmEnable(): Boolean {
        return developerOptions.useRTM.apply {
            Logger.i(TAG, "is rtm:${LogConverter.enable(this)}")
        }
    }

    override fun rtmEnable(enable: Boolean) {
        Logger.i(TAG, "set rtm:${LogConverter.enable(enable)}")
        developerOptions.useRTM = enable
    }

    override fun isDataChannelEnable(): Boolean {
        return developerOptions.useDataChannel.apply {
            Logger.i(TAG, "is rtc data channel:${LogConverter.enable(this)}")
        }
    }

    override fun dataChannelEnable(enable: Boolean) {
        Logger.i(TAG, "set rtc data channel:${LogConverter.enable(enable)}")
        developerOptions.useDataChannel = enable
    }

    override fun isLastMileEnable(): Boolean {
        return developerOptions.useLastMile.apply {
            Logger.i(TAG, "is last mile:${LogConverter.enable(this)}")
        }
    }

    override fun lastMileEnable(enable: Boolean) {
        Logger.i(TAG, "set lastMile:${LogConverter.enable(enable)}")
        developerOptions.useLastMile = enable
    }

    override fun isShowVideoData(): Boolean {
        return developerOptions.showVideoData
    }

    override fun showVideoData(show: Boolean) {
        Logger.i(TAG, "set show video data:${LogConverter.enable(show)}")
        developerOptions.showVideoData = show
    }

    override fun isVideoScoreEnable(): Boolean {
        return developerOptions.videoRate.apply {
            Logger.i(TAG, "is video score:${LogConverter.enable(this)}")
        }
    }

    override fun videoScoreEnable(enable: Boolean) {
        Logger.i(TAG, "set video score:${LogConverter.enable(enable)}")
        developerOptions.videoRate = enable
    }

    override fun isChangeMainScreenVideoBG(): Boolean {
        return developerOptions.changeVideoBG.apply {
            Logger.i(TAG, "change main screen video background:${LogConverter.enable(this)}")
        }
    }

    override fun changeMainScreenVideoBG(change: Boolean) {
        Logger.i(TAG, "change main screen video background:${LogConverter.enable(change)}")
        developerOptions.changeVideoBG = change
    }

    override fun isQualityReport(): Boolean {
        return developerOptions.qualityReport.apply {
            Logger.i(TAG, "quality report:${LogConverter.enable(this)}")
        }
    }

    override fun qualityReport(open: Boolean) {
        Logger.i(TAG, "quality report:${LogConverter.enable(open)}")
        developerOptions.qualityReport = open
    }

    override fun wifiAp(open: Boolean) {
        Logger.i(TAG, "set wifiAp opened:$open")
        developerOptions.wifiAP = open
    }

    override fun loginWeWork(login: Boolean) {
        Logger.i(TAG, "login weWork, login:${login}")
        developerOptions.weWorkLogin = login
    }

    override fun showDeveloper(show: Boolean) {
        Logger.i(TAG, "show developer, show:$show")
        developerOptions.showDeveloper = show
    }

    override fun openNetworkEvaluation(open: Boolean) {
        Logger.i(TAG, "open network evaluation, open:$open")
        developerOptions.networkEvaluation = open
    }

    companion object {
        private const val TAG = "[Repository][developer]"
    }
}