package io.agora.avc.repository.impl

import io.agora.avc.repository.EquipmentRepository
import io.agora.avc.utils.AppUtils
import io.agora.avc.utils.DeviceUtils
import io.agora.avc.utils.LanguageUtils
import javax.inject.Inject

class EquipmentRepositoryImpl @Inject constructor() : EquipmentRepository {
    override fun getAppVersionName(): String {
        return AppUtils.getAppVersionName()
    }

    override fun getPlatform(): String {
        return DeviceUtils.getPlatform()
    }

    override fun getEquipmentInfo(): String {
        return DeviceUtils.getModel()
    }

    override fun getLangType(): Int {
        return if (LanguageUtils.isChinese()) {
            1
        } else {
            0
        }
    }

    override fun getFeatureType(): Long {
        return 0L
    }
}