package io.agora.avc.repository.impl

import android.text.TextUtils
import io.agora.avc.bo.MeetingNotification
import io.agora.avc.bo.NoticeCode
import io.agora.avc.config.KEY_REQUEST_ID
import io.agora.avc.repository.NotificationRepository
import io.agora.logger.Logger
import java.util.concurrent.CopyOnWriteArrayList
import javax.inject.Inject

class NotificationRepositoryImpl @Inject constructor() : NotificationRepository {

    private val notificationList = CopyOnWriteArrayList<MeetingNotification>()

    override fun getNotificationList() = CopyOnWriteArrayList(notificationList)

    @Synchronized
    override fun add(meetingNotification: MeetingNotification) {
        notificationList.add(meetingNotification)
    }

    @Synchronized
    override fun remove(meetingNotificationType: Int) {
        notificationList.forEach {
            if (it.notificationType == meetingNotificationType) {
                notificationList.remove(it)
                return@forEach
            }
        }
    }

    @Synchronized
    override fun removeAt(position: Int) {
        if (position in 0 until notificationList.size) {
            notificationList.removeAt(position)
        } else {
            Logger.e(
                TAG,
                "removeAt method, IndexOutOfBoundsException, length=${notificationList.size}, index=$position"
            )
        }
    }

    @Synchronized
    override fun set(index: Int, meetingNotification: MeetingNotification) {
        if (index in 0 until notificationList.size) {
            notificationList[index] = meetingNotification
        } else {
            Logger.e(
                TAG,
                "set method, IndexOutOfBoundsException, length=${notificationList.size}, index=$index"
            )
        }
    }

    override fun clear() {
        notificationList.clear()
    }

    @Synchronized
    override fun remove(code: NoticeCode) {
        notificationList.forEach {
            if (it.code == code) {
                notificationList.remove(it)
                return@forEach
            }
        }
    }

    @Synchronized
    override fun remove(requestId: String) {
        notificationList.forEach {
            if (TextUtils.equals(it.data?.getString(KEY_REQUEST_ID), requestId)) {
                notificationList.remove(it)
                return@forEach
            }
        }
    }

    @Synchronized
    override fun remove(meetingNotification: MeetingNotification) {
        notificationList.remove(meetingNotification)
    }

    companion object {
        private const val TAG = "[Repository][Notification]"
    }
}