package io.agora.avc.screenshare

import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import androidx.core.app.NotificationCompat
import androidx.core.content.ContextCompat
import io.agora.avc.R
import io.agora.avc.manager.notice.NotificationController
import io.agora.avc.manager.notice.NotificationController.createNotificationChannel
import io.agora.avc.manager.notice.NotificationController.createSmallIcon

object ScreenShareNotification {
    private const val ACTION_CLICK_NOTIFICATION = "io.agora.avc.AgoraActivity"

    fun getBuilder(context: Context): NotificationCompat.Builder {
        createNotificationChannel(
            context,
            NotificationController.SCREEN_SHARE_CHANNEL_ID,
            R.string.avc_screen_share_notification_channel_name,
            R.string.avc_screen_share_notification_channel_des
        )
        return NotificationCompat
            .Builder(context, NotificationController.SCREEN_SHARE_CHANNEL_ID)
            .setSmallIcon(createSmallIcon())
            .setColor(ContextCompat.getColor(context, R.color.avc_color_primary))
            .setContentTitle(context.getString(R.string.avc_screen_share_notification_title))
            .setContentText(context.getString(R.string.avc_screen_share_notification_content))
            .setWhen(System.currentTimeMillis())
            .setPriority(NotificationCompat.PRIORITY_LOW)
            .setShowWhen(false)
            .setContentIntent(getContentIntent(context))
    }

    private fun getContentIntent(context: Context): PendingIntent {
        return PendingIntent.getActivity(
            context,
            0,
            Intent(ACTION_CLICK_NOTIFICATION),
            PendingIntent.FLAG_UPDATE_CURRENT
        )
    }
}