package io.agora.avc.utils

import android.os.Bundle
import android.view.View
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentManager
import io.agora.logger.Logger

class FragmentTracker : FragmentManager.FragmentLifecycleCallbacks() {

    override fun onFragmentViewCreated(
        fm: FragmentManager,
        f: Fragment,
        v: View,
        savedInstanceState: Bundle?
    ) {
        super.onFragmentViewCreated(fm, f, v, savedInstanceState)
        Logger.i(TAG, "${f.javaClass.canonicalName} viewCreated")
    }

    override fun onFragmentViewDestroyed(fm: FragmentManager, f: Fragment) {
        super.onFragmentViewDestroyed(fm, f)
        Logger.i(TAG, "${f.javaClass.canonicalName} viewDestroyed")
    }

    companion object {
        private const val TAG = "[Comm][FragmentTracker]"
    }
}