package io.agora.avc.utils

import io.agora.avc.MyApplication
import java.util.*

object LanguageUtils {
    /**
     * Return the locale.
     *
     * @return the locale
     */
    fun getCurrentLocale(): Locale {
        return if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.N) {
            MyApplication.app.resources.configuration.locales[0]
        } else {
            MyApplication.app.resources.configuration.locale
        }
    }

    fun isChinese(): Boolean {
        return Locale("zh").language == getCurrentLocale().language ||
                Locale("zh_CN").language == getCurrentLocale().language ||
                Locale("zh_TW").language == getCurrentLocale().language
    }
}