package io.agora.avc.utils

import java.util.regex.Pattern

object RegexUtils {
    const val REGEX_EN = "^[a-zA-Z]+$"

    /**
     * Return whether input matches regex of Chinese character.
     *
     * @param input The input.
     * @return `true`: yes<br></br>`false`: no
     */
    fun isEn(input: CharSequence?): Boolean {
        return RegexUtils.isMatch(REGEX_EN, input)
    }

    /**
     * Return whether input matches the regex.
     *
     * @param regex The regex.
     * @param input The input.
     * @return `true`: yes<br></br>`false`: no
     */
    fun isMatch(regex: String?, input: CharSequence?): Boolean {
        return input != null && input.isNotEmpty() && Pattern.matches(regex, input)
    }

}