package io.agora.avc.utils;

import android.content.Context;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;

import io.agora.avc.MyApplication;

public class TelephonyWatcher {

    private TelephonyManager mTelephonyManager;

    private PhoneStateListener mPhoneStateListener;

    public TelephonyWatcher() {
        mTelephonyManager = (TelephonyManager) MyApplication.Companion.getApp().getSystemService(Context.TELEPHONY_SERVICE);
    }

    public void startWatch(PhoneStateListener phoneStateListener) {
        this.mPhoneStateListener = phoneStateListener;

        if (mTelephonyManager != null && mPhoneStateListener != null) {
            mTelephonyManager.listen(mPhoneStateListener, PhoneStateListener.LISTEN_CALL_STATE);
        }
    }

    public void stopWatch() {
        if (mTelephonyManager != null && mPhoneStateListener != null) {
            mTelephonyManager.listen(mPhoneStateListener, PhoneStateListener.LISTEN_NONE);
        }
    }
}
