package io.agora.avc.utils

import android.os.SystemClock
import androidx.annotation.NonNull
import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.*
import java.util.concurrent.TimeUnit

object TimeUtils {
    private val DAY_NAME = arrayOf("周日", "周一", "周二", "周三", "周四", "周五", "周六")

    fun elapsedRealTime(): Long {
        return SystemClock.elapsedRealtime()
    }

    /**
     * return mm:ss
     *
     * @param time
     * @return
     */
    fun getMMSS(time: Long): String {
        return String.format(
            "%02d:%02d",
            TimeUnit.MILLISECONDS.toMinutes(time) -
                    TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(time)),  // The change is in this line
            TimeUnit.MILLISECONDS.toSeconds(time) -
                    TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time))
        )
    }

    /**
     * return hh:mm:ss
     *
     * @param time
     * @return
     */
    fun getRoomTime(time: Long): String {
        if (time < 60 * 60 * 1000) {
            return getMMSS(time)
        }
        return String.format(
            "%02d:%02d:%02d",
            TimeUnit.MILLISECONDS.toHours(time),
            TimeUnit.MILLISECONDS.toMinutes(time) -
                    TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(time)),  // The change is in this line
            TimeUnit.MILLISECONDS.toSeconds(time) -
                    TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time))
        )
    }


    /**
     * return hh:mm:ss
     *
     * @param time
     * @return
     */
    fun getHHMMSS(time: Long): String {
        return String.format(
            "%02d:%02d:%02d",
            TimeUnit.MILLISECONDS.toHours(time),
            TimeUnit.MILLISECONDS.toMinutes(time) -
                    TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(time)),  // The change is in this line
            TimeUnit.MILLISECONDS.toSeconds(time) -
                    TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time))
        )
    }

    /**
     * 不同一周的显示时间格式
     *
     * @param time
     * @param timeFormat
     * @return
     */
    private fun getTime(time: Long, timeFormat: String): String {
        val format = SimpleDateFormat(timeFormat)
        return format.format(Date(time))
    }

    /**
     * 当天的显示时间格式
     *
     * @param time
     * @return
     */
    private fun getHourAndMin(time: Long): String {
        val format = SimpleDateFormat("HH:mm")
        return format.format(Date(time))
    }

    /**
     * 不同年的显示时间格式
     *
     * @param time
     * @param yearTimeFormat
     * @return
     */
    private fun getYearTime(time: Long, yearTimeFormat: String): String {
        val format = SimpleDateFormat(yearTimeFormat)
        return format.format(Date(time))
    }

    /**
     * 获取聊天时间
     * 仿微信聊天时间格式化显示。
     * 在同一年的显示规则：
     * 如果是当天显示格式为 HH:mm 例：14:45
     * 如果是昨天,显示格式为 昨天 HH:mm 例：昨天 13:12
     * 如果是在同一周 显示格式为 周一 HH:mm 例：周一14:05
     * 如果不是同一周则显示格式为 M月d日 早上或者其它 HH:mm 例： 2月5日 早上10:10
     *
     *
     * 不在同一年的显示规则：
     * 显示格式为 yyyy年M月d日 晚上或者其它 HH:mm 例：2016年2月5日 晚上18:05
     *
     * @param timestamp
     * @return
     */
    fun getChatTime(timestamp: Long): String? {
        var result = ""
        val todayCalendar = Calendar.getInstance()
        val otherCalendar = Calendar.getInstance()
        otherCalendar.timeInMillis = timestamp
        var timeFormat = "M月d日 HH:mm"
        var yearTimeFormat = "yyyy年M月d日 HH:mm"
        var am_pm = ""
        val hour = otherCalendar[Calendar.HOUR_OF_DAY]
        if (hour >= 0 && hour < 6) {
            am_pm = "凌晨"
        } else if (hour >= 6 && hour < 12) {
            am_pm = "早上"
        } else if (hour == 12) {
            am_pm = "中午"
        } else if (hour > 12 && hour < 18) {
            am_pm = "下午"
        } else if (hour >= 18) {
            am_pm = "晚上"
        }
        timeFormat = "M月d日 " + am_pm + "HH:mm"
        yearTimeFormat = "yyyy年M月d日 " + am_pm + "HH:mm"
        val yearTemp = todayCalendar[Calendar.YEAR] == otherCalendar[Calendar.YEAR]
        result = if (yearTemp) {
            val todayMonth = todayCalendar[Calendar.MONTH]
            val otherMonth = otherCalendar[Calendar.MONTH]
            if (todayMonth == otherMonth) { //表示是同一个月
                val temp = todayCalendar[Calendar.DATE] - otherCalendar[Calendar.DATE]
                when (temp) {
                    0 -> getTime(timestamp, "HH:mm:ss")
                    1 -> "昨天 " + TimeUtils.getHourAndMin(timestamp)
                    2, 3, 4, 5, 6 -> {
                        val dayOfMonth = otherCalendar[Calendar.WEEK_OF_MONTH]
                        val todayOfMonth = todayCalendar[Calendar.WEEK_OF_MONTH]
                        if (dayOfMonth == todayOfMonth) { //表示是同一周
                            val dayOfWeek = otherCalendar[Calendar.DAY_OF_WEEK]
                            if (dayOfWeek != 1) { //判断当前是不是星期日     如想显示为：周日 12:09 可去掉此判断
                                TimeUtils.DAY_NAME.get(otherCalendar[Calendar.DAY_OF_WEEK] - 1)
                                    .toString() + TimeUtils.getHourAndMin(
                                    timestamp
                                )
                            } else {
                                getTime(timestamp, timeFormat)
                            }
                        } else {
                            getTime(timestamp, timeFormat)
                        }
                    }
                    else -> getTime(timestamp, timeFormat)
                }
            } else {
                getTime(timestamp, timeFormat)
            }
        } else {
            TimeUtils.getYearTime(timestamp, yearTimeFormat)
        }
        return result
    }

    /**
     * Return the current time in milliseconds.
     *
     * @return the current time in milliseconds
     */
    fun getNowMills(): Long {
        return System.currentTimeMillis()
    }

    /**
     * Milliseconds to the formatted time string.
     *
     * @param millis The milliseconds.
     * @param format The format.
     * @return the formatted time string
     */
    fun millis2String(millis: Long, @NonNull format: DateFormat): String? {
        return format.format(Date(millis))
    }

}