package io.agora.avc.video;

import android.content.Context;
import android.content.res.Configuration;
import android.provider.Settings;
import android.view.OrientationEventListener;

public class OrientationListener extends OrientationEventListener {
    private int orientation = Configuration.ORIENTATION_UNDEFINED;
    private Context context;
    private OnOrientationChangedListener orientationChangedListener;

    public OrientationListener(Context context) {
        super(context);
        this.context = context;
    }

    @Override
    public void onOrientationChanged(int degree) {
        int currentOrientation = Configuration.ORIENTATION_UNDEFINED;
        if (degree > 0 && degree < 45) {
            currentOrientation = Configuration.ORIENTATION_PORTRAIT;
        } else if (degree > 45 && degree < 135) {
            currentOrientation = Configuration.ORIENTATION_LANDSCAPE;
        } else if (degree > 135 && degree < 225) {
            currentOrientation = Configuration.ORIENTATION_PORTRAIT;
        } else if (degree > 225 && degree < 315) {
            currentOrientation = Configuration.ORIENTATION_LANDSCAPE;
        } else if (degree > 315 && degree < 360) {
            currentOrientation = Configuration.ORIENTATION_PORTRAIT;
        }
        if (currentOrientation != Configuration.ORIENTATION_UNDEFINED && currentOrientation != orientation) {
            this.orientation = currentOrientation;
            boolean autoRotation = false;
            try {
                autoRotation = Settings.System.getInt(context.getContentResolver(), Settings.System.ACCELEROMETER_ROTATION) == 1;
            } catch (Settings.SettingNotFoundException e) {
                e.printStackTrace();
            }
            if (autoRotation && orientationChangedListener != null) {
                orientationChangedListener.onOrientationChanged(this.orientation);
            }
        }
    }

    public void registerOrientationChangedListener(OnOrientationChangedListener listener) {
        this.orientationChangedListener = listener;
    }

    public void unregisterOrientationChangedListener() {
        this.orientationChangedListener = null;
    }

    interface OnOrientationChangedListener {
        void onOrientationChanged(int orientation);
    }
}