package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import androidx.databinding.DataBindingUtil
import io.agora.avc.R
import io.agora.avc.databinding.AvcLayoutAttendeeIconBinding

/***
 * Created by liqilin on 2019/7/15
 *
 */
class AttendeeIconView @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ConstraintLayout(context, attributeSet, defStyleAttr) {

    private val binding = DataBindingUtil.inflate<AvcLayoutAttendeeIconBinding>(
        LayoutInflater.from(context),
        R.layout.avc_layout_attendee_icon,
        this,
        true
    )

    init {
//        val typedValue = TypedValue()
//        context.theme.resolveAttribute(R.attr.colorPrimary, typedValue, true)
//        binding.icon.setColorFilter(typedValue.data)
        context.obtainStyledAttributes(attributeSet, R.styleable.AvcAttendeeIconView).apply {
            getDrawable(R.styleable.AvcAttendeeIconView_android_src).apply {
                binding.icon.setImageDrawable(this)
            }
            recycle()
        }
    }

    override fun setClickable(clickable: Boolean) {
        super.setClickable(clickable)

//        changeImage()
    }

    private fun changeImage() {
        if (!isClickable) {
            binding.icon.setImageResource(R.drawable.avc_ic_attendees_unclickable)
        } else {
            binding.icon.setImageResource(R.drawable.avc_ic_attendees)
        }
    }

    fun setAttendeesNumber(count: Int) {
        if (count > 999) {
            binding.number.text = "999+"
        } else {
            binding.number.text = "$count"
        }
        binding.number.isVisible = count > 0
    }
}