package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import io.agora.avc.R
import io.agora.avc.databinding.AvcLayoutAudioButtonBinding
import io.agora.avc.utils.TimeUtils

class AudioRecordButton @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ConstraintLayout(context, attributeSet, defStyleAttr) {

    private val binding = DataBindingUtil.inflate<AvcLayoutAudioButtonBinding>(
        LayoutInflater.from(context),
        R.layout.avc_layout_audio_button,
        this,
        true
    )

    fun starting() {
        binding.ivItem.setImageResource(R.drawable.avc_ic_audio_recording)
        binding.progressBar.visibility = View.VISIBLE
        binding.tvItem.text = "00:00"
    }

    fun stopping() {
        binding.ivItem.setImageResource(R.drawable.avc_ic_audio_record_start)
        binding.progressBar.visibility = View.GONE
        binding.tvItem.text = context.getString(R.string.avc_audio_button_start_text)
    }

    fun setTiming(time: Long) {
        binding.tvItem.text = TimeUtils.getMMSS(time * 250)
        binding.progressBar.progress = ((time / 240f) * 600).toInt()
    }

}