package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import androidx.appcompat.widget.AppCompatImageView
import io.agora.avc.R
import io.agora.avc.bo.NetworkQuality

/***
 * Created by liqilin on 2019/5/7
 *
 */
class AvcSignalQualityImageView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : AppCompatImageView(context, attrs, defStyleAttr) {

    private var styleType = 0

    private var idResPool: Int = 0
    private var idResSoft: Int = 0
    private var idResGood: Int = 0
    private var idResUnknown: Int = 0
    private var idResDown: Int = 0

    var quality = NetworkQuality.UNKNOWN
        private set

    var bizConnected = true
        set(value) {
            field = value
            if (value) {
                setQuality(quality, true)
            } else {
                setImageResource(R.drawable.avc_ic_network_disconnected)
            }
        }

    init {
        val a = context.obtainStyledAttributes(attrs, R.styleable.AvcSignalQualityImageView)
        styleType = a.getInt(R.styleable.AvcSignalQualityImageView_avc_styleType, 0)
        a.recycle()

        idResPool = R.drawable.avc_ic_signal_poor
        idResSoft = R.drawable.avc_ic_signal_soft
        idResGood = R.drawable.avc_ic_signal_good
        idResUnknown = R.drawable.avc_ic_signal_unknown
        idResDown = R.drawable.avc_ic_signal_down
    }

    override fun onFinishInflate() {
        super.onFinishInflate()

        setImageResource(idResUnknown)
    }

    /**
     * if biz connected show rtc quality, else show disconnected
     * @param quality rtc quality
     */
    fun setQuality(quality: Int, refreshForce:Boolean = false) {
        if (this.quality == quality && !refreshForce) {
            return
        }

        this.quality = quality

        if (!bizConnected) {
            return
        }

        when (quality) {
            NetworkQuality.EXCELLENT,
            NetworkQuality.GOOD -> setImageResource(idResGood)
            NetworkQuality.POOR -> setImageResource(idResSoft)
            NetworkQuality.BAD,
            NetworkQuality.VBAD -> setImageResource(idResPool)
            NetworkQuality.DOWN -> setImageResource(idResDown)
            else -> setImageResource(idResUnknown)
        }
    }
}
