package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import com.google.android.material.chip.Chip
import com.google.android.material.chip.ChipGroup
import io.agora.avc.R
import io.agora.avc.utils.StringUtils

class CallRatingChips @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ChipGroup(context, attrs, defStyleAttr) {

    fun getCheckedTags(): MutableList<Int> {
        return checkedChipIds.map {
            findViewById<View>(it).tag as Int
        } as MutableList<Int>
    }

    fun setChecked(tag: Int) {
        for (index in 0 until childCount) {
            getChildAt(index).apply {
                if (this.tag == tag) {
                    check(id)
                }
            }
        }
    }

    fun addItems(list: List<Pair<Int, Int>>) {
        list.forEach {
            addItem(it)
        }
    }

    fun hasChecked() = checkedChipIds.isNotEmpty()

    private fun addItem(item: Pair<Int, Int>) {
        createItem().apply {
            this.tag = item.first
            this.text = StringUtils.getString(item.second)
            this@CallRatingChips.addView(this)
        }
    }

    private fun createItem() =
        LayoutInflater.from(context).inflate(R.layout.avc_item_call_rating_chip, this, false) as Chip

}