package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import io.agora.avc.R
import io.agora.avc.databinding.AvcLayoutDumpProgressbarBinding

class DumpProgressBar @JvmOverloads constructor(
    context: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {

    private val binding =
        AvcLayoutDumpProgressbarBinding.inflate(LayoutInflater.from(context), this, true)

    var max: Int = resources.getInteger(R.integer.avc_dump_progress_max)
        set(value) {
            field = value
            binding.roundProgressBar.max = value
        }

    var progress: Int = 0
        set(value) {
            field = value
            binding.roundProgressBar.progress = value
            binding.tvNumber.text = "${value}S"
            binding.tvNumber.isVisible = value > 0
        }
}