package io.agora.avc.widget

import android.animation.Animator
import android.animation.AnimatorInflater
import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import androidx.appcompat.widget.AppCompatImageView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.databinding.DataBindingUtil
import io.agora.avc.R
import io.agora.avc.databinding.AvcLayoutDumpTipsBinding

class DumpingTips @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ConstraintLayout(context, attributeSet, defStyleAttr) {

    private val binding = DataBindingUtil.inflate<AvcLayoutDumpTipsBinding>(
        LayoutInflater.from(context),
        R.layout.avc_layout_dump_tips,
        this,
        true
    )

    private val dumpingAnimation: Animator by lazy {
        AnimatorInflater.loadAnimator(context, R.animator.avc_animator_dumping_tips)
    }

    fun getIcon(): AppCompatImageView {
        return binding.ivItem
    }

    fun setTipsVisible(visible: Boolean) {
        if (visible) {
            dumpingAnimation.setTarget(binding.ivItem)
            dumpingAnimation.start()
            visibility = View.VISIBLE
        } else {
            visibility = View.GONE
            dumpingAnimation.cancel()
        }
    }

}