package io.agora.avc.widget

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import androidx.annotation.StringRes
import androidx.appcompat.widget.AppCompatTextView
import androidx.constraintlayout.widget.ConstraintLayout
import io.agora.avc.R

class EntrancePopupWindow constructor(activity: Activity) : TipPopupWindow(activity) {

    private var text: CharSequence? = null
    private var tipsView: View? = null
    private var tips: AppCompatTextView? = null

    constructor(activity: Activity, textString: CharSequence) : this(activity) {
        text = textString
    }

    constructor(activity: Activity, @StringRes textId: Int) : this(activity) {
        text = activity.getText(textId)
    }

    override fun getCustomView(): View {
        tipsView = LayoutInflater.from(activity)
            .inflate(R.layout.avc_layout_entrance_tips, container, false) as ConstraintLayout
        tips = tipsView?.findViewById(R.id.tips)
        tips?.text = text
        return tipsView!!
    }

    override fun getParentLayoutId(): Int {
        return R.layout.avc_layout_pop_tip_entrance
    }

    fun updateText(textString: CharSequence) {
        text = textString
        tips?.text = textString
    }
}