package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.LinearLayout
import androidx.databinding.DataBindingUtil
import io.agora.avc.R
import io.agora.avc.bo.VideoStats
import io.agora.avc.databinding.AvcLayoutMediaStaticsBinding

/***
 * Created by liqilin on 2019-12-17
 *
 */
class MediaStaticsView @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyleAttr: Int = 0
) : LinearLayout(context, attributeSet, defStyleAttr) {

    private val binding by lazy {
        DataBindingUtil.inflate<AvcLayoutMediaStaticsBinding>(
            LayoutInflater.from(
                context
            ), R.layout.avc_layout_media_statics, this, true
        )
    }

    private var isBigUI = false

    init {
        orientation = VERTICAL

        val typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AvcMediaStaticsView)
        isBigUI = typedArray.getInt(R.styleable.AvcMediaStaticsView_avc_ui_type, 0) == 0
        typedArray.recycle()
    }

    override fun onFinishInflate() {
        super.onFinishInflate()

        binding.isBigUI = isBigUI
    }

    fun setVideoStatics(statics: VideoStats?) {
        // null can also be assigned to replace last statics
        binding.videoStats = statics
    }

    fun setVolume(volume: Int) {
        binding.volumeValue = volume
    }
}