package io.agora.avc.widget

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import androidx.core.view.isVisible
import io.agora.avc.R
import io.agora.avc.bo.NetworkQuality
import io.agora.avc.bo.NetworkSignal
import io.agora.avc.databinding.AvcPopSignalQualityBinding
import io.agora.avc.utils.StringUtils
import io.agora.avc.utils.ThemeUtils

class SignalQualityPopupWindow constructor(
    activity: Activity,
    var networkSignal: NetworkSignal? = null,
) : TipPopupWindow(activity) {

    private val binding: AvcPopSignalQualityBinding by lazy {
        AvcPopSignalQualityBinding.inflate(LayoutInflater.from(activity))
    }

    override fun getCustomView(): View {
        setData()
        return binding.root
    }

    fun setNetWorkSignal(networkSignal: NetworkSignal) {
        this.networkSignal = networkSignal
        setData()
    }

    private fun getQuality(quality: Int): Pair<Int, Int> {
        return when (quality) {
            NetworkQuality.EXCELLENT,
            NetworkQuality.GOOD -> Pair(
                R.string.avc_media_quality_good,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalGoodColor)
            )
            NetworkQuality.POOR -> Pair(
                R.string.avc_media_quality_poor,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalSoftColor)
            )
            NetworkQuality.BAD,
            NetworkQuality.VBAD -> Pair(
                R.string.avc_media_quality_bad,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalPoorColor)
            )
            else -> Pair(
                R.string.avc_media_quality_unknown,
                ThemeUtils.getAttrValue(context = activity, R.attr.signalUnknownColor)
            )
        }
    }

    private fun setData() {
        networkSignal?.let {
            binding.tvMessage.text =
                activity.getString(if (it.bizConnected) R.string.avc_room_rtm_connected else R.string.avc_room_rtm_disconnected)
            getQuality(it.quality).let { _pair ->
                binding.tvSignalQuality.text = StringUtils.getString(_pair.first)
                binding.tvSignalQuality.setTextColor(_pair.second)
            }

            binding.tvLatency.text = if (it.lastMileDelay == -1 || it.lastMileDelay > 200) " -" else "${it.lastMileDelay}ms"
            binding.tvPacketReceive.text =
                if (it.downLossRate == -1) "-" else "${it.downLossRate}% " + activity.getString(R.string.avc_media_receive)
            binding.tvPacketSend.text =
                if (it.upLossRate == -1) "-" else "${it.upLossRate}% " + activity.getString(R.string.avc_media_send)

            binding.groupRtc.isVisible = it.bizConnected
        }
    }
}