package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.GestureDetector
import android.view.MotionEvent
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.GestureDetectorCompat
import io.agora.avc.utils.ConvertUtils
import kotlin.math.abs

class SlidingConstraintLayout @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {

    private var gestureDetector: GestureDetectorCompat? = null
    private var gestureDetectorListener: GestureDetector.OnGestureListener? = null
    private var slidingEventListener: OnSlidingEventListener? = null
    private var distance: Float = ConvertUtils.dp2px(20f).toFloat()
    private var minVelocity: Float = 100f

    init {
        gestureDetectorListener = object : GestureDetector.OnGestureListener {
            override fun onDown(e: MotionEvent?): Boolean {
                return false
            }

            override fun onShowPress(e: MotionEvent?) {

            }

            override fun onSingleTapUp(e: MotionEvent?): Boolean {
                return true
            }

            override fun onScroll(
                e1: MotionEvent?,
                e2: MotionEvent?,
                distanceX: Float,
                distanceY: Float
            ): Boolean {
                return true
            }

            override fun onLongPress(e: MotionEvent?) {

            }

            override fun onFling(
                e1: MotionEvent?,
                e2: MotionEvent?,
                velocityX: Float,
                velocityY: Float
            ): Boolean {
                if (e1 == null || e2 == null) {
                    return false
                }
                if (e1.x - e2.x > distance && abs(velocityX) > minVelocity) {
                    slidingEventListener?.onSlidingLeft()
                } else if (e2.x - e1.x > distance && abs(velocityX) > minVelocity) {
                    slidingEventListener?.onSlidingRight()
                }

                if (e1.y - e2.y > distance && abs(velocityY) > minVelocity) {
                    slidingEventListener?.onSlidingTop()
                } else if (e2.y - e1.y > distance && abs(velocityX) > minVelocity) {
                    slidingEventListener?.onSlidingBottom()
                }
                return true
            }

        }
        gestureDetector = GestureDetectorCompat(context, gestureDetectorListener)
    }

    override fun onTouchEvent(event: MotionEvent?): Boolean {
        gestureDetector?.onTouchEvent(event)
        return true
    }


    interface OnSlidingEventListener {
        fun onSlidingLeft()
        fun onSlidingRight()
        fun onSlidingTop()
        fun onSlidingBottom()
    }

    fun setOnSlidingEventListener(listener: OnSlidingEventListener?) {
        this.slidingEventListener = listener
    }
}