package io.agora.avc.widget

import android.content.Context
import android.util.AttributeSet
import android.view.GestureDetector
import android.view.MotionEvent
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.GestureDetectorCompat
import io.agora.avc.utils.ConvertUtils
import kotlin.math.abs

open class SwipeBackConstraintLayout @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0
) : ConstraintLayout(context, attrs, defStyleAttr) {
    private var gestureDetector: GestureDetectorCompat? = null
    private var gestureDetectorListener: GestureDetector.OnGestureListener? = null
    private var onSwipeListener: OnSwipeListener? = null
    private val flipDistance = ConvertUtils.dp2px(20f).toFloat()
    private val minVelocity = 0f
    private var startX: Float = 0f
    private var endX: Float = 0f
    private var startY: Float = 0f
    private var endY: Float = 0f

    init {
        init()
    }

    private fun init() {
        gestureDetectorListener = object : GestureDetector.OnGestureListener {
            override fun onDown(e: MotionEvent): Boolean {
                return false
            }

            override fun onShowPress(e: MotionEvent) {}
            override fun onSingleTapUp(e: MotionEvent): Boolean {
                return false
            }

            override fun onScroll(
                e1: MotionEvent,
                e2: MotionEvent,
                distanceX: Float,
                distanceY: Float
            ): Boolean {
                return false
            }

            override fun onLongPress(e: MotionEvent) {

            }

            override fun onFling(
                e1: MotionEvent,
                e2: MotionEvent,
                velocityX: Float,
                velocityY: Float
            ): Boolean {
                val beginX = e1.x
                val endX = e2.x
                val beginY = e1.y
                val endY = e2.y

                if (abs(endX - beginX) > abs(endY - beginY) &&
                    endX - beginX > flipDistance &&
                    abs(velocityX) > minVelocity
                ) {
                    onSwipeListener?.onSlideRight()
                    return true
                }
                return false
            }
        }
        gestureDetector = GestureDetectorCompat(context, gestureDetectorListener)
    }

    override fun onInterceptTouchEvent(ev: MotionEvent?): Boolean {
        when (ev?.action) {
            MotionEvent.ACTION_DOWN -> {
                startX = ev.x
                startY = ev.y
            }
            MotionEvent.ACTION_UP -> {
                endX = ev.x
                endY = ev.y
            }
        }
        if (abs(endX - startX) > abs(endY - startY) && endX - startX > flipDistance) {
            return true
        }
        return super.onInterceptTouchEvent(ev)
    }

    override fun onTouchEvent(event: MotionEvent): Boolean {
        gestureDetector?.onTouchEvent(event)
        return true
    }

    interface OnSwipeListener {
        fun onSlideRight()
    }

    fun setOnSwipeListener(listener: OnSwipeListener?) {
        onSwipeListener = listener
    }
}