package io.agora.avc.widget.bottomsheet

import android.os.Bundle
import android.view.LayoutInflater
import androidx.annotation.DrawableRes
import androidx.core.os.bundleOf
import androidx.fragment.app.Fragment
import io.agora.avc.R
import io.agora.avc.databinding.AvcFragmentBottomSheetBinding
import io.agora.avc.databinding.AvcItemBottomSheetBinding
import io.agora.avc.extensions.safeNavigate
import io.agora.frame.base.BaseSheetDialogFragment
import io.agora.frame.base.BaseViewModel

const val KEY_SERIAL_NUMBER = "key_serial_number"
const val KEY_BOTTOM_SHEET_TITLE = "key_bottom_sheet_title"

class BottomSheetFragment :
    BaseSheetDialogFragment<BaseViewModel, AvcFragmentBottomSheetBinding>() {

    private var serialNumber = -1

    private val viewModel by lazy {
        getViewModel(requireActivity().viewModelStore, BottomSheetViewModel::class.java)
    }

    override fun getLayoutId() = R.layout.avc_fragment_bottom_sheet

    override fun initialize(savedInstanceState: Bundle?) {
        serialNumber = arguments?.getInt(KEY_SERIAL_NUMBER) ?: -1
        mBinding.tvTitle.text = arguments?.getString(KEY_BOTTOM_SHEET_TITLE) ?: ""
        viewModel.queryActions(serialNumber)
    }

    override fun allocObserver() {

        viewModel.actionsLiveData.observe(this) {
            if (serialNumber == it.first) {
                it.second.forEach { _action ->
                    addAction(_action.text, _action.icon)
                }
            }
        }
    }

    private fun addAction(text: String, @DrawableRes icon: Int?) {
        context?.let {
            AvcItemBottomSheetBinding.inflate(LayoutInflater.from(it), mBinding.bottomSheet, false)
                .apply {
                    mBinding.bottomSheet.addView(this.root)
                    tvAction.text = text
                    icon?.let { _icon ->
                        ivAction.setImageResource(_icon)
                    }
                    this.root.setOnClickListener {
                        viewModel.callback.postValue(Pair(serialNumber, text))
                        onBackPressed()
                    }
                }
        }
    }

    companion object {

        fun navigateTo(
            fragment: Fragment,
            bottomSheetViewModel: BottomSheetViewModel,
            title: String,
            actions: Array<BottomSheetAction>,
            callback: (String) -> Unit,
        ): Int {

            val serialNumber = System.currentTimeMillis().toInt()
            fragment.safeNavigate(
                R.id.action_global_bottom_sheet,
                bundleOf(
                    KEY_SERIAL_NUMBER to serialNumber,
                    KEY_BOTTOM_SHEET_TITLE to title,
                )
            )

            bottomSheetViewModel.addActions(serialNumber, actions)
            bottomSheetViewModel.callback.observe(fragment) {
                if (serialNumber == it.first) {
                    callback(it.second)
                }
            }
            return serialNumber
        }
    }
}