package io.agora.avc.widget.bottomsheet

import android.app.Application
import android.util.SparseArray
import androidx.annotation.DrawableRes
import androidx.lifecycle.MutableLiveData
import io.agora.avc.base.AppViewModel
import io.agora.avc.biz.AppController
import io.agora.frame.base.livedata.EventLiveData
import javax.inject.Inject

/**
 * global view model
 */
class BottomSheetViewModel @Inject constructor(
    application: Application,
    appContainer: AppController,
) : AppViewModel(application, appContainer) {

    private val actions = SparseArray<Array<BottomSheetAction>>()

    val actionsLiveData =
        MutableLiveData<Pair<Int, Array<BottomSheetAction>>>()

    val callback = EventLiveData<Pair<Int, String>>()

    fun queryActions(serialNumber: Int) {
        if (actions.get(serialNumber) != null) {
            actionsLiveData.postValue(Pair(serialNumber, actions.get(serialNumber)))
        }
    }

    fun addActions(serialNumber: Int, actions: Array<BottomSheetAction>) {
        this.actions.put(serialNumber, actions)
    }
}

data class BottomSheetAction(val text: String, @DrawableRes val icon: Int? = null)