package io.agora.avc.widget.divider;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

public class VerticalDivider extends RecyclerView.ItemDecoration {

    private Drawable mDivider;

    private int mPaddingLeft;

    private int mPaddingRight;

    private boolean mDrawFirst;

    private boolean mDrawLast;

    public VerticalDivider(Context context, int divider, int paddingLeft, int paddingRight) {
        this(context, divider, paddingLeft, paddingRight, true, true);
    }

    public VerticalDivider(Context context, int divider, int paddingLeft, int paddingRight, boolean drawFirst, boolean drawLast) {
        mDivider = ContextCompat.getDrawable(context, divider);
        this.mPaddingLeft = paddingLeft;
        this.mPaddingRight = paddingRight;
        this.mDrawFirst = drawFirst;
        this.mDrawLast = drawLast;
    }

    @Override
    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        drawVertical(c, parent);
    }

    public void drawVertical(Canvas c, RecyclerView parent) {
        final int left = parent.getPaddingLeft() + mPaddingLeft;
        final int right = parent.getWidth() - parent.getPaddingRight() - mPaddingRight;

        final int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; i++) {
            final View child = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(child);
            if (!mDrawFirst) {
                if (position == 0) {
                    continue;
                }
            }
            if (!mDrawLast) {
                int totalCount = 0;
                if (null != parent.getAdapter()) {
                    totalCount = parent.getAdapter().getItemCount();
                }
                if (position == totalCount - 1) {
                    continue;
                }
            }
            final RecyclerView.LayoutParams params = (RecyclerView.LayoutParams) child.getLayoutParams();
            final int top = child.getBottom() + params.bottomMargin;
            final int bottom = top + mDivider.getIntrinsicHeight();
            mDivider.setBounds(left, top, right, bottom);
            mDivider.draw(c);
        }
    }

    @Override
    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.set(0, 0, 0, mDivider.getIntrinsicHeight());
    }

}