package io.agora.avc.widget.pop

import android.view.View
import androidx.appcompat.widget.AppCompatImageView
import androidx.appcompat.widget.AppCompatTextView
import androidx.core.view.isVisible
import androidx.recyclerview.widget.RecyclerView
import io.agora.avc.R
import io.agora.avc.bo.MeetingStatus

class StatusPopViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

    private val tvStatus: AppCompatTextView = itemView.findViewById(R.id.tvStatus)
    private val tvDuration: AppCompatTextView = itemView.findViewById(R.id.tvDuration)
    private val ivIcon: AppCompatImageView = itemView.findViewById(R.id.ivIcon)

    fun onBind(item: MeetingStatus, updateDuration: Boolean = false) {
        if (!updateDuration) {

            tvStatus.text = item.description

            if (item.itemType == MeetingStatus.ITEM_TYPE_CLOUD_RECORDING) {
                ivIcon.setImageResource(R.drawable.avc_shape_status_cloud_recording_icon)
                tvDuration.isVisible = true
            } else {
                ivIcon.setImageResource(R.drawable.avc_shape_status_dump_icon)
                tvDuration.isVisible = false
            }
        }

        tvDuration.text = item.duration
    }

    fun updateDuration(duration: String) {
        tvDuration.text = duration
    }
}