/*
 * Decompiled with CFR 0.152.
 */
package io.github.amyassist.amy.restresources.chat;

import io.github.amyassist.amy.core.di.annotation.Reference;
import io.github.amyassist.amy.core.natlang.DialogHandler;
import io.github.amyassist.amy.core.natlang.Response;
import io.github.amyassist.amy.restresources.chat.AnswerConsumer;
import io.github.amyassist.amy.restresources.chat.ChatService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="chat")
public class ChatResource {
    public static final String PATH = "chat";
    @Reference
    private DialogHandler handler;
    @Reference
    private ChatService chatService;

    @POST
    @Path(value="register")
    @Produces(value={"text/plain"})
    public String registerUser() {
        AnswerConsumer w = new AnswerConsumer();
        UUID uuid = this.handler.createDialog(w::addToQueue);
        this.chatService.addUser(uuid);
        w.setQueue(this.chatService.getQueue(uuid));
        return uuid.toString();
    }

    @POST
    @Path(value="input")
    @Consumes(value={"text/plain"})
    @Operation(summary="Process natural language text input", description="This is the remote amy chatbot. It can be used to interact with the natural language interface of amy. The possible intents are the same as using the local console or the speech interaction", tags={"chat"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="the natural language text input has been processed successfully and the response contains the answer", content={@Content(examples={@ExampleObject(summary="This response represent that you don't have new mails.", name="new mails")})}), @ApiResponse(responseCode="500", description="the input could not be precessed")})
    public void useAmy(@QueryParam(value="langInput") String input, @QueryParam(value="clientUUID") String uuid) {
        try {
            this.handler.process(input, UUID.fromString(uuid));
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException("unknown UUID " + uuid, (Throwable)e, Response.Status.FORBIDDEN);
        }
    }

    @POST
    @Path(value="response")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response receiveResponse(String uuidString) {
        Queue<Response> queue;
        UUID uuid;
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException("unknown UUID " + uuidString, (Throwable)e, Response.Status.FORBIDDEN);
        }
        try {
            queue = this.chatService.getQueue(uuid);
        }
        catch (NoSuchElementException e) {
            return Response.text((String)"").build();
        }
        Response response = queue.poll();
        if (response == null) {
            return Response.text((String)"").build();
        }
        return response;
    }
}

