/*
 * Decompiled with CFR 0.152.
 */
package io.github.amyassist.amy.plugin.webpush;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.amyassist.amy.core.di.annotation.Reference;
import io.github.amyassist.amy.core.di.annotation.Service;
import io.github.amyassist.amy.plugin.webpush.SimpleWebPushService;
import io.github.amyassist.amy.plugin.webpush.WebPushNameService;
import io.github.amyassist.amy.plugin.webpush.WebPushService;
import io.github.amyassist.amy.plugin.webpush.model.Notification;

@Service
public class SimpleWebPushServiceImpl
implements SimpleWebPushService {
    @Reference
    private WebPushService webPushService;
    @Reference
    private WebPushNameService webPushNameService;

    @Override
    public void sendPushNotification(int id, Notification notification) {
        this.webPushService.sendPushNotification(id, this.marshallNotification(notification));
    }

    @Override
    public void sendPushNotification(String name, Notification notification) {
        this.webPushNameService.sendPushNotification(name, this.marshallNotification(notification));
    }

    private byte[] marshallNotification(Notification notification) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsBytes((Object)new Payload(notification));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private class Payload {
        public Notification notification;

        public Payload(Notification notification) {
            this.notification = notification;
        }
    }
}

