/*
 * Decompiled with CFR 0.152.
 */
package io.github.amyassist.amy.plugin.webpush;

import io.github.amyassist.amy.core.di.annotation.Reference;
import io.github.amyassist.amy.core.di.annotation.Service;
import io.github.amyassist.amy.plugin.webpush.WebPushNameService;
import io.github.amyassist.amy.plugin.webpush.WebPushService;
import io.github.amyassist.amy.plugin.webpush.model.Subscription;
import io.github.amyassist.amy.plugin.webpush.persistence.SubscriptionEntity;
import io.github.amyassist.amy.plugin.webpush.persistence.SubscriptionStorage;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Service
public class WebPushNameServiceImpl
implements WebPushNameService {
    @Reference
    private Logger logger;
    @Reference
    private SubscriptionStorage subscriptionStorage;
    @Reference
    private WebPushService webPushService;

    @Override
    public void sendPushNotification(String name, byte[] payload) {
        for (int id : this.getIDs(name)) {
            this.webPushService.sendPushNotification(id, payload);
        }
    }

    @Override
    public int subscribe(Subscription subscription, String name) {
        int subscribe = this.webPushService.subscribe(subscription);
        this.setName(subscribe, name);
        return subscribe;
    }

    @Override
    public String getName(int id) {
        return ((SubscriptionEntity)this.subscriptionStorage.getById(id)).getTag();
    }

    @Override
    public List<Integer> getIDs(String name) {
        return this.subscriptionStorage.getEntitiesWithTag(name).stream().map(SubscriptionEntity::getPersistentId).collect(Collectors.toList());
    }

    @Override
    public List<Integer> getAllIDs() {
        return this.subscriptionStorage.getAll().stream().map(SubscriptionEntity::getPersistentId).collect(Collectors.toList());
    }

    @Override
    public void setName(int id, String name) {
        SubscriptionEntity entity = (SubscriptionEntity)this.subscriptionStorage.getById(id);
        if (entity == null) {
            throw new NoSuchElementException("No Subscription with id: " + id);
        }
        entity.setTag(name);
        this.subscriptionStorage.save(entity);
    }
}

