/*
 * Decompiled with CFR 0.152.
 */
package io.github.amyassist.amy.plugin.webpush;

import io.github.amyassist.amy.core.di.annotation.PostConstruct;
import io.github.amyassist.amy.core.di.annotation.Reference;
import io.github.amyassist.amy.core.di.annotation.Service;
import io.github.amyassist.amy.core.plugin.api.IStorage;
import io.github.amyassist.amy.plugin.webpush.WebPushService;
import io.github.amyassist.amy.plugin.webpush.model.Subscription;
import io.github.amyassist.amy.plugin.webpush.persistence.SubscriptionEntity;
import io.github.amyassist.amy.plugin.webpush.persistence.SubscriptionStorage;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Base64;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.PushService;
import nl.martijndwars.webpush.Utils;
import org.apache.http.HttpResponse;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;

@Service
public class WebPushServiceImpl
implements WebPushService {
    private static final String PUBLIC_KEY = "PublicKey";
    private static final String PRIVATE_KEY = "PrivateKey";
    @Reference
    private Logger logger;
    @Reference
    private IStorage storage;
    @Reference
    private SubscriptionStorage subscriptionStorage;

    @PostConstruct
    private void setup() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (!this.storage.has(PUBLIC_KEY) || !this.storage.has(PRIVATE_KEY)) {
            this.logger.info("Create new key pair");
            try {
                KeyPair keyPair = this.generateKeyPair();
                byte[] publicKey = Utils.encode((ECPublicKey)((ECPublicKey)keyPair.getPublic()));
                byte[] privateKey = Utils.encode((ECPrivateKey)((ECPrivateKey)keyPair.getPrivate()));
                this.storage.put(PUBLIC_KEY, Base64.getUrlEncoder().encodeToString(publicKey));
                this.storage.put(PRIVATE_KEY, Base64.getUrlEncoder().encodeToString(privateKey));
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
                this.logger.error("Could not generate key pair", (Throwable)e);
            }
        }
    }

    private KeyPair generateKeyPair() throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"prime256v1");
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("ECDH", "BC");
        keyPairGenerator.initialize((AlgorithmParameterSpec)parameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    private Future<HttpResponse> sendPushMessage(SubscriptionEntity sub, byte[] payload) {
        try {
            Notification notification = new Notification(sub.getEndpoint(), this.getUserPublicKey(sub), this.getAuthAsBytes(sub), payload);
            String publicKey = this.storage.get(PUBLIC_KEY);
            String privateKey = this.storage.get(PRIVATE_KEY);
            PushService pushService = new PushService(publicKey, privateKey, "testSubject");
            return pushService.sendAsync(notification);
        }
        catch (IOException | GeneralSecurityException | JoseException e) {
            throw new IllegalStateException(e);
        }
    }

    private PublicKey getUserPublicKey(SubscriptionEntity sub) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory kf = KeyFactory.getInstance("ECDH", "BC");
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        byte[] decode = Base64.getUrlDecoder().decode(sub.getKey());
        ECPoint point = ecSpec.getCurve().decodePoint(decode);
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
        return kf.generatePublic((KeySpec)pubSpec);
    }

    private byte[] getAuthAsBytes(SubscriptionEntity sub) {
        return Base64.getUrlDecoder().decode(sub.getAuth());
    }

    @Override
    public int subscribe(Subscription subscription) {
        SubscriptionEntity subscriptionEntity = new SubscriptionEntity(subscription.getEndpoint(), subscription.getAuth(), subscription.getKey());
        this.subscriptionStorage.save(subscriptionEntity);
        return subscriptionEntity.getPersistentId();
    }

    @Override
    public void unsubscribe(int id) {
        if (this.subscriptionStorage.getById(id) == null) {
            throw new NoSuchElementException("No Subscription with id: " + id);
        }
        this.subscriptionStorage.deleteById(id);
    }

    @Override
    public String getPublicVAPIDKey() {
        return this.storage.get(PUBLIC_KEY);
    }

    @Override
    public void sendPushNotification(int id, byte[] payload) {
        SubscriptionEntity subscriptionEntity = (SubscriptionEntity)this.subscriptionStorage.getById(id);
        if (subscriptionEntity == null) {
            throw new NoSuchElementException("No Subscription with id: " + id);
        }
        this.sendPushMessage(subscriptionEntity, payload);
    }
}

