/*
 * Decompiled with CFR 0.152.
 */
package io.github.amyassist.amy.plugin.webpush.message;

import io.github.amyassist.amy.core.di.annotation.Reference;
import io.github.amyassist.amy.messagehub.annotations.MessageReceiver;
import io.github.amyassist.amy.messagehub.annotations.Subscription;
import io.github.amyassist.amy.messagehub.topic.TopicLevel;
import io.github.amyassist.amy.messagehub.topic.TopicName;
import io.github.amyassist.amy.plugin.webpush.SimpleWebPushService;
import io.github.amyassist.amy.plugin.webpush.WebPushNameService;
import io.github.amyassist.amy.plugin.webpush.model.Notification;
import io.github.amyassist.amy.plugin.webpush.model.NotificationImp;
import java.util.Collections;

@MessageReceiver
public class NotificationMessageReceiver {
    @Reference
    private SimpleWebPushService simpleWebPushService;
    @Reference
    private WebPushNameService webPushNameService;

    @Subscription(value="user/+/notification")
    public void notifyUser(String message, TopicName topic) {
        String userName = ((TopicLevel)topic.getTopicLevels().get(1)).getStringRepresentation();
        NotificationImp notification = new NotificationImp("Amy Message Notification", message, "assets/icons/icon-512x512.png", new int[]{100, 50, 100}, "", Collections.emptyList());
        if (userName.equals("all")) {
            for (int id : this.webPushNameService.getAllIDs()) {
                this.simpleWebPushService.sendPushNotification(id, (Notification)notification);
            }
        } else {
            this.simpleWebPushService.sendPushNotification(userName, (Notification)notification);
        }
    }
}

