/*
 * Decompiled with CFR 0.152.
 */
package io.github.amyassist.amy.plugin.webpush.rest;

import io.github.amyassist.amy.core.di.annotation.Reference;
import io.github.amyassist.amy.plugin.webpush.WebPushNameService;
import io.github.amyassist.amy.plugin.webpush.WebPushService;
import io.github.amyassist.amy.plugin.webpush.model.SubscriptionImpl;
import io.github.amyassist.amy.plugin.webpush.rest.Subscription;
import java.util.NoSuchElementException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="webpush/subscription")
public class WebPushSubscriptionRescource {
    @Reference
    private WebPushService webPushService;
    @Reference
    private WebPushNameService webPushNameService;

    @GET
    @Path(value="key")
    @Produces(value={"text/plain"})
    public String getPublicVAPIDKey() {
        return this.webPushService.getPublicVAPIDKey();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public int subscribe(@QueryParam(value="clientName") String name, Subscription subscription) {
        return this.webPushNameService.subscribe(new SubscriptionImpl(subscription.endpoint.toString(), subscription.keys.auth, subscription.keys.p256dh), name);
    }

    @DELETE
    @Path(value="{id}")
    public void unsubscribe(@PathParam(value="id") int id) {
        try {
            this.webPushService.unsubscribe(id);
        }
        catch (NoSuchElementException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @POST
    @Path(value="{id}")
    @Consumes(value={"text/plain"})
    public void setName(@PathParam(value="id") int id, String name) {
        try {
            this.webPushNameService.setName(id, name);
        }
        catch (NoSuchElementException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }
}

