/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.backed;

import io.github.h800572003.backed.BackendCancelException;
import io.github.h800572003.backed.BackendContext;
import io.github.h800572003.backed.BackendRunnable;
import io.github.h800572003.backed.BackendRuntimeException;
import io.github.h800572003.backed.IBackendService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BackedPeriodService
implements BackendContext,
IBackendService {
    private boolean isUp = false;
    protected String name;
    protected long closeTimeout = 0L;
    private BackendRunnable execute;
    private String memo;
    private ScheduledExecutorService newSingleThreadExecutor;
    private Future<?> future;
    private final long period;
    private String[] args;
    private final List<BackendContext.ShutdownHookEvent> shutdownHookEvents = new ArrayList<BackendContext.ShutdownHookEvent>();

    public BackedPeriodService(String name, long period) {
        this(name, period, 30);
    }

    public BackedPeriodService(String name, long period, int closeTimeout) {
        if (closeTimeout <= 0) {
            throw new BackendRuntimeException("\u95dc\u9589\u7b49\u5f85\u6642\u9593\u9700\u5927\u65bc0");
        }
        if (period <= 0L) {
            throw new BackendRuntimeException("\u9031\u671f\u9700\u5927\u65bc0");
        }
        this.closeTimeout = closeTimeout;
        this.name = name;
        this.period = period;
        Runtime.getRuntime().addShutdownHook(new Thread("stopCommand"){

            @Override
            public void run() {
                BackedPeriodService.this.shutdownHookEvents.forEach(i -> i.shutdown());
                BackedPeriodService.this.close();
            }
        });
    }

    public void execute() {
        this.execute.execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start(BackendRunnable execute, String ... args) {
        if (this.execute != null) {
            throw new BackendRuntimeException("\u670d\u52d9\u5df2\u555f\u52d5");
        }
        this.args = args;
        this.newSingleThreadExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, BackedPeriodService.this.name);
            }
        });
        this.execute = execute;
        BackedPeriodService backedPeriodService = this;
        synchronized (backedPeriodService) {
            this.isUp = true;
        }
        this.future = this.newSingleThreadExecutor.scheduleWithFixedDelay(this::execute, 2L, this.period, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        BackedPeriodService backedPeriodService = this;
        synchronized (backedPeriodService) {
            this.isUp = false;
        }
        if (this.future != null) {
            this.newSingleThreadExecutor.shutdown();
            this.callBackend();
            try {
                this.future.cancel(true);
            }
            finally {
                this.newSingleThreadExecutor.shutdownNow();
                this.newSingleThreadExecutor = null;
            }
        }
    }

    private void callBackend() {
        try {
            this.newSingleThreadExecutor.awaitTermination(this.closeTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void updateMemo(String memo) {
        this.memo = memo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkUp() throws BackendCancelException {
        BackedPeriodService backedPeriodService = this;
        synchronized (backedPeriodService) {
            if (!this.isUp) {
                throw new BackendCancelException("\u670d\u52d9\u4e2d\u65b7");
            }
        }
    }

    @Override
    public void registerShutdownHook(BackendContext.ShutdownHookEvent shutdownHookEvent) {
        this.shutdownHookEvents.add(shutdownHookEvent);
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }
}

