/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.batch;

import io.github.h800572003.batch.IBactchTaskConfig;
import io.github.h800572003.batch.IBactchTaskExecuter;
import io.github.h800572003.batch.IBactchTaskExecuterContext;
import io.github.h800572003.batch.IBactchTaskHolder;
import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.exception.CancelExecpetion;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BactchTaskHolder
implements IBactchTaskHolder,
IBactchTaskExecuterContext {
    private static final Logger log = LoggerFactory.getLogger(BactchTaskHolder.class);
    protected IBactchTaskExecuter bactchTaskExecuter;
    private ScheduledExecutorService newSingleThreadExecutor;
    private ScheduledFuture<?> future;
    private boolean isCallDown = false;
    private IBactchTaskConfig config;
    private boolean isOn = false;

    public BactchTaskHolder(IBactchTaskConfig config, IBactchTaskExecuter bactchTaskExecuter) {
        this.config = config;
        this.bactchTaskExecuter = bactchTaskExecuter;
    }

    @Override
    public void on() {
        this.start();
    }

    private synchronized void start() {
        if (this.newSingleThreadExecutor == null) {
            this.newSingleThreadExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "BACTCH_" + this.config.getCode()));
            log.info("start code{}", (Object)this.config.getCode());
            this.future = this.newSingleThreadExecutor.scheduleWithFixedDelay(this::execute, this.getDelay(), this.config.getPeriod(), TimeUnit.SECONDS);
            this.isOn = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void off() {
        if (this.future == null) throw new ApBusinessException("batch " + this.config.getCode() + "\u672a\u57f7\u884c", new Object[0]);
        if (this.isCallDown) throw new ApBusinessException("batch " + this.config.getCode() + "\u505c\u6b62\u4e2d", new Object[0]);
        this.isCallDown = true;
        this.newSingleThreadExecutor.shutdown();
        this.future.cancel(true);
        try {
            log.info("down code{}", (Object)this.config.getCode());
            this.newSingleThreadExecutor.shutdown();
            this.future.cancel(true);
            try {
                if (this.newSingleThreadExecutor.awaitTermination(this.config.getCloseTimeout(), TimeUnit.SECONDS)) return;
                List<Runnable> shutdownNow = this.newSingleThreadExecutor.shutdownNow();
                log.info("shutdownNow size:{}", (Object)shutdownNow.size());
                return;
            }
            catch (InterruptedException e) {
                this.newSingleThreadExecutor.shutdownNow();
            }
            return;
        }
        finally {
            this.newSingleThreadExecutor = null;
            this.future = null;
            this.isCallDown = false;
            this.isOn = false;
            log.info("down code{} end", (Object)this.config.getCode());
        }
    }

    public void execute() {
        try {
            this.bactchTaskExecuter.execute(this);
        }
        catch (Exception e) {
            log.info("\u767c\u751f\u7570\u5e38", (Throwable)e);
        }
    }

    @Override
    public void checkUp() throws CancelExecpetion {
        if (this.isCallDown) {
            throw new CancelExecpetion("\u7a0b\u5f0f\u4e2d\u65b7", new Object[0]);
        }
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public String getCode() {
        return this.config.getCode();
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public long getPeriod() {
        return this.config.getPeriod();
    }

    @Override
    public long getCloseTimeout() {
        return this.config.getCloseTimeout();
    }

    @Override
    public String getNextSec() {
        if (this.future == null) {
            return "";
        }
        return this.future.getDelay(TimeUnit.SECONDS) + "";
    }

    @Override
    public long getDelay() {
        return this.config.getDelay();
    }
}

