/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.h800572003.cmd.BaseCmdHander;
import io.github.h800572003.cmd.CmdCodesCofing;
import io.github.h800572003.cmd.ICmdHander;
import io.github.h800572003.cmd.ICmdService;
import io.github.h800572003.properties.Code;
import io.github.h800572003.properties.IProperties;
import io.github.h800572003.properties.IPropertiesService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetPropHandler
extends BaseCmdHander
implements ICmdHander {
    private static final Logger log = LoggerFactory.getLogger(GetPropHandler.class);
    private IPropertiesService propertiesService;
    private ObjectMapper objectMapper;

    public GetPropHandler(ICmdService service, IPropertiesService propertiesService, ObjectMapper objectMapper) {
        super(CmdCodesCofing.Codes.GETPRO.name(), service);
        this.propertiesService = propertiesService;
        this.objectMapper = objectMapper;
    }

    @Override
    public String cmd(String action) {
        if (StringUtils.isBlank((CharSequence)action)) {
            List<Code> category = this.propertiesService.getCategory();
            try {
                return this.objectMapper.writeValueAsString(category);
            }
            catch (JsonProcessingException e) {
                log.error("\u8f49\u63db\u5931\u6557", (Throwable)e);
                return "\u8f49\u63db\u5931\u6557";
            }
        }
        List<IProperties> propertie = this.propertiesService.getPropertie(action);
        try {
            return this.objectMapper.writeValueAsString(propertie);
        }
        catch (JsonProcessingException e) {
            log.error("\u8f49\u63db\u5931\u6557", (Throwable)e);
            return "\u8f49\u63db\u5931\u6557";
        }
    }
}

