/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.cmd;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.h800572003.cmd.BaseCmdHander;
import io.github.h800572003.cmd.CmdCodesCofing;
import io.github.h800572003.cmd.ICmdHander;
import io.github.h800572003.cmd.ICmdService;
import io.github.h800572003.exception.ApBusinessException;
import io.github.h800572003.scheduling.ISchedulingContext;
import io.github.h800572003.scheduling.ISchedulingManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchCmdHander
extends BaseCmdHander
implements ICmdHander {
    private static final Logger log = LoggerFactory.getLogger(WatchCmdHander.class);
    private final ISchedulingManager schedulingManager;
    private final ObjectMapper objectMapper;

    public WatchCmdHander(ICmdService service, ISchedulingManager schedulingManager, ObjectMapper objectMapper) {
        super(CmdCodesCofing.Codes.WATCH.name(), service);
        this.schedulingManager = schedulingManager;
        this.objectMapper = objectMapper;
    }

    @Override
    public String cmd(String action) {
        if (StringUtils.isNotBlank((CharSequence)action)) {
            throw new ApBusinessException("\u7121\u63d0\u4f9b\u6b64\u547d\u547d:{0}", action);
        }
        ISchedulingContext context = this.schedulingManager.getContext();
        try {
            return this.objectMapper.writeValueAsString((Object)context);
        }
        catch (JsonProcessingException e) {
            log.error("\u8f49\u63db\u5931\u6557", (Throwable)e);
            return "\u8f49\u63db\u5931\u6557";
        }
    }
}

