/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.codegenerate;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.h800572003.codegenerate.CodeGenerater;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class AassertThatGeneratrer {
    private Set<String> excludes = Sets.newHashSet();

    public AassertThatGeneratrer() {
        this.add("getClass");
    }

    public void add(String excludeMethod) {
        this.excludes.add(excludeMethod);
    }

    public void generateAssertThat(Class<?> excep, Class<?> ... source) {
        try (PrintStream out = System.out;){
            new CodeGenerater(new Holder(excep, source)::getLines).write(out);
        }
        catch (IOException e) {
            System.out.print("\u7522\u88fd\u932f\u8aa4" + e.getMessage());
        }
    }

    public void generateAssertThat(Class<?> excep) {
        try (PrintStream out = System.out;){
            new CodeGenerater(new Holder(excep, new Class[0])::getLines).write(out);
        }
        catch (IOException e) {
            System.out.print("\u7522\u88fd\u932f\u8aa4" + e.getMessage());
        }
    }

    class Holder {
        private static final String ASSERT_THAT_S_S_IS_EQUAL_TO_S_S = "assertThat(%s.%s()).isEqualTo(%s.%s()); ";
        final Class<?> excep;
        final Class<?>[] source;

        public Holder(Class<?> excep, Class<?> ... source) {
            this.excep = excep;
            this.source = source;
        }

        public List<String> getLines() {
            ArrayList line = Lists.newArrayList();
            Method[] methods = this.excep.getMethods();
            String clsseNmae = this.excep.getSimpleName();
            String objectName = StringUtils.uncapitalize((String)clsseNmae);
            for (Method mm : methods) {
                boolean startsWith = mm.getName().startsWith("get");
                if (!startsWith) continue;
                String methodName = mm.getName();
                if (AassertThatGeneratrer.this.excludes.contains(methodName)) continue;
                boolean isFind = false;
                for (Class<?> pClass : this.source) {
                    try {
                        pClass.getMethod(methodName, new Class[0]);
                        line.add(String.format(ASSERT_THAT_S_S_IS_EQUAL_TO_S_S, objectName, methodName, StringUtils.uncapitalize((String)pClass.getSimpleName()), methodName));
                        isFind = true;
                        break;
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                    }
                }
                if (isFind) continue;
                line.add(String.format(ASSERT_THAT_S_S_IS_EQUAL_TO_S_S, objectName, methodName, "-", methodName));
            }
            return line;
        }
    }
}

