/*
 * Decompiled with CFR 0.152.
 */
package io.github.h800572003.codegenerate;

import com.google.common.collect.Lists;
import io.github.h800572003.codegenerate.CodeGenerater;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class BeanMapperGenerater {
    public void generate(Class<?> source, Class<?> target) {
        try (PrintStream out = System.out;){
            new CodeGenerater(new Holder(source, target)::getLines).write(out);
        }
        catch (IOException e) {
            System.out.print("\u7522\u88fd\u932f\u8aa4" + e.getMessage());
        }
    }

    class Holder {
        Class<?> source;
        Class<?> target;

        public Holder(Class<?> source, Class<?> target) {
            this.source = source;
            this.target = target;
        }

        public List<String> getLines() {
            ArrayList line = Lists.newArrayList();
            Method[] methods = this.target.getMethods();
            String clsseNmae = this.target.getSimpleName();
            String objectName = StringUtils.uncapitalize((String)clsseNmae);
            line.add(String.format("public %s to(%s %s) {", clsseNmae, this.source.getSimpleName(), StringUtils.uncapitalize((String)this.source.getSimpleName())));
            line.add(String.format("    if ( %s == null ) {", StringUtils.uncapitalize((String)this.source.getSimpleName())));
            line.add(String.format("        return null;", new Object[0]));
            line.add(String.format("    }", new Object[0]));
            line.add(String.format("", new Object[0]));
            line.add(String.format("    final %s %s = new %s();", clsseNmae, objectName, clsseNmae));
            line.add(String.format("", new Object[0]));
            for (Method mm : methods) {
                boolean startsWith = mm.getName().startsWith("set");
                if (!startsWith) continue;
                String setName = mm.getName();
                line.add(String.format("    %s.%s(%s.%s());", objectName, mm.getName(), StringUtils.uncapitalize((String)this.source.getSimpleName()), setName.replace("set", "get")));
            }
            line.add(String.format("    return %s;", objectName));
            line.add(String.format("}", new Object[0]));
            return line;
        }
    }
}

